/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.impl.CapabilitySectionDAO;
import com.quantumdata.sct.dao.impl.ModelCapabilityDAO;
import com.quantumdata.sct.dao.impl.StandardCapabilityDAO;
import com.quantumdata.sct.dao.impl.StandardDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import com.quantumdata.sct.dao.vo.CapabilitySectionVO;
import com.quantumdata.sct.dao.vo.ModelCapabilityVO;
import com.quantumdata.sct.dao.vo.StandardCapabilityVO;
import com.quantumdata.sct.dao.vo.StandardVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.wizard.ActivityMainPanel;
import com.quantumdata.sct.gui.wizard.CapabilitySectionPage;
import com.quantumdata.sct.gui.wizard.NoModelCapabilitiesFound;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class CDFWizard
extends ActivityMainPanel {
    private Hashtable m_modelCapabilities;
    private Vector m_standardCapabilities;
    private ModelCapabilityVO m_modelCapabilityVO;
    private StandardCapabilityVO m_standardCapabilityVO;

    public CDFWizard(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI);
    }

    private void readModelCapabilities(String string) throws Exception {
        this.m_modelCapabilities = new Hashtable();
        this.m_standardCapabilities = new Vector();
        ModelCapabilityDAO modelCapabilityDAO = (ModelCapabilityDAO)XMLDAOFactory.getModelCapabilityDAO();
        this.m_modelCapabilityVO = (ModelCapabilityVO)modelCapabilityDAO.read(string);
        Collection collection = this.m_modelCapabilityVO.getCapabilities();
        StandardCapabilityDAO standardCapabilityDAO = (StandardCapabilityDAO)XMLDAOFactory.getStandardCapabilityDAO();
        this.m_standardCapabilityVO = (StandardCapabilityVO)standardCapabilityDAO.read(SCTSelection.instance().getStandardID());
        Collection collection2 = this.m_standardCapabilityVO.getCapabilities();
        if (collection.isEmpty()) {
            throw new NoModelCapabilitiesFound("No Capabilities found for the selected model", string);
        }
        for (ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO : collection) {
            this.m_modelCapabilities.put(modelCapabilityElementVO.getCapabilityId(), modelCapabilityElementVO);
        }
        for (AbstractCapabilityVO abstractCapabilityVO : collection2) {
            this.m_standardCapabilities.add(abstractCapabilityVO.getId());
        }
    }

    public void initCDF(String string) throws Exception {
        Object object;
        Component[] componentArray;
        this.clearCards();
        this.readModelCapabilities(string);
        CapabilitySectionDAO capabilitySectionDAO = (CapabilitySectionDAO)XMLDAOFactory.getCapabilitySectionDAO();
        IPersistable[] iPersistableArray = capabilitySectionDAO.findByAll();
        for (int i = 0; i < iPersistableArray.length; ++i) {
            componentArray = ((CapabilitySectionVO)iPersistableArray[i]).getName();
            object = ((CapabilitySectionVO)iPersistableArray[i]).values();
            Vector vector = new Vector();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.m_standardCapabilities.contains(string2)) continue;
                if (this.m_modelCapabilities.containsKey(string2)) {
                    vector.add(this.m_modelCapabilities.get(string2));
                    continue;
                }
                System.out.println("Missing capability " + string2);
                ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = new ModelCapabilityVO.ModelCapabilityElementVO();
                modelCapabilityElementVO.setCapabilityId(string2);
                modelCapabilityElementVO.setRequired(false);
                modelCapabilityElementVO.setSupported(false);
                this.m_modelCapabilityVO.setModelCapabilityElementVO(modelCapabilityElementVO);
                this.m_modelCapabilities.put(string2, modelCapabilityElementVO);
                vector.add(this.m_modelCapabilities.get(string2));
            }
            if (vector.isEmpty()) continue;
            this.addCard((String)componentArray, new CapabilitySectionPage((String)componentArray, vector));
        }
        this.getCancelButton().setVisible(false);
        this.getFinishButton().setVisible(true);
        Container container = this.getFinishButton().getParent();
        componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!((SCTButton)componentArray[i]).getText().equalsIgnoreCase("Finish")) continue;
            object = componentArray[i];
            container.remove((Component)object);
            container.add((Component)object);
        }
        this.validateBtn();
    }

    public void validateBtn() {
        CapabilitySectionPage capabilitySectionPage = (CapabilitySectionPage)this.getCurrentCard();
        if (capabilitySectionPage != null) {
            String string = "Capability : " + (capabilitySectionPage.getTestIndex() + 1) + " of " + capabilitySectionPage.getTestCount();
            this.getStepCountButton().setText(string);
        } else {
            this.getStepCountButton().setText("No capabilities!");
        }
        this.setBackBtnEnabled(!this.isFirstPage() || !this.isFirstTest());
        this.setNextBtnEnabled(!this.isLastPage() || !this.isLastTest());
        this.setBackSecBtnVisible(false);
        this.setNextSecBtnVisible(false);
        this.setFinishBtnEnabled(true);
        this.setCancelBtnEnabled(false);
    }

    private boolean isFirstTest() {
        CapabilitySectionPage capabilitySectionPage = (CapabilitySectionPage)this.getCurrentCard();
        if (capabilitySectionPage != null) {
            return capabilitySectionPage.isFirstTest();
        }
        return true;
    }

    private boolean isLastTest() {
        CapabilitySectionPage capabilitySectionPage = (CapabilitySectionPage)this.getCurrentCard();
        if (capabilitySectionPage != null) {
            return capabilitySectionPage.isLastTest();
        }
        return true;
    }

    public void nextButtonAction(ActionEvent actionEvent) {
        CapabilitySectionPage capabilitySectionPage = (CapabilitySectionPage)this.getCurrentCard();
        if (capabilitySectionPage != null) {
            if (capabilitySectionPage.nextButtonAction(actionEvent)) {
                super.nextButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    public void backButtonAction(ActionEvent actionEvent) {
        CapabilitySectionPage capabilitySectionPage = (CapabilitySectionPage)this.getCurrentCard();
        if (capabilitySectionPage != null) {
            if (capabilitySectionPage.backButtonAction(actionEvent)) {
                super.backButtonAction(actionEvent);
            }
            this.validateBtn();
        }
    }

    public boolean finishAction() {
        boolean bl = super.finishAction();
        if (bl) {
            try {
                ModelCapabilityDAO modelCapabilityDAO = (ModelCapabilityDAO)XMLDAOFactory.getModelCapabilityDAO();
                this.m_modelCapabilityVO.setDirty();
                modelCapabilityDAO.update(this.m_modelCapabilityVO);
                MessageOptionPane.ShowMessage(this.getParent(), "For the new CDF to take effect, the TME must now be restarted.  Please note that changes to the CDF will not affect devices that have been previously created and selected.", "Status");
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    void GetStandardCapabilities() {
        try {
            StandardDAO standardDAO = (StandardDAO)XMLDAOFactory.getStandardDAO();
            IPersistable[] iPersistableArray = standardDAO.findByAll();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                StandardVO standardVO = (StandardVO)iPersistableArray[i];
                if (i != 0) continue;
                SCTSelection.instance().setStandardID(standardVO.getId().toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

